using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.IO;

namespace Application_Monitor
{
    /// <summary>
    /// This form is used to browse the selected file
    /// </summary>
    public partial class frmOffline : Form
    {
        #region Member Variable(s) Declaration
        string strFilePath = null;
        #endregion

        public frmOffline()
        {
            InitializeComponent();

        }

        #region Private Event(s) Declaration
        private void Offline_Load(object sender, EventArgs e)
        {
            this.AcceptButton = btnOK;
            this.CancelButton = btnCancel;
        }

        private void btnBrowse_Click(object sender, EventArgs e)
        {
            OpenFileDialogBox();
        }

        private void openFlDialog_FileOk(object sender, CancelEventArgs e)
        {           
            
                txtBrowse.Text = openFlDialog.FileName;
            
        }

        private void btnCancel_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void btnOK_Click(object sender, EventArgs e)
        {
            
            if (txtBrowse.Text != string.Empty)
            {
                if (!File.Exists(txtBrowse.Text))
                {
                    MessageBox.Show("File does not exsits", "", MessageBoxButtons.OK, MessageBoxIcon.Information);
                }
                else
                {
                    string strExtension= txtBrowse.Text.Substring(txtBrowse.Text.LastIndexOf('.'));
                    if (strExtension.Trim().ToLower() == Constants.SPO2_FILE_EXTENSION.Trim().ToLower())
                    {
                        this.Hide();
                        frmPulseOximteryOffline objfrmPulseOffline = new frmPulseOximteryOffline();
                        
                        objfrmPulseOffline.FilePath = txtBrowse.Text.Trim();
                        objfrmPulseOffline.ShowDialog();
                        this.Close();

                    }
                    else
                    {
                        MessageBox.Show("Please select or enter an " + "SpO2" + " file.", "", MessageBoxButtons.OK, MessageBoxIcon.Information);
                    }
                }
            }
            else
            {
                MessageBox.Show("Please select or enter an " + "SpO2" + " file.", "", MessageBoxButtons.OK, MessageBoxIcon.Information);
            }
        }

        private void frmOffline_KeyDown(object sender, KeyEventArgs e)
        {
            if (e.KeyCode == Keys.B)
            {
                OpenFileDialogBox();
            }
        }
        #endregion

        #region Private  Function(s) Declaration
        private void OpenFileDialogBox()
        {
            string strPath = string.Empty;
            string strExtension = string.Empty;
            string strFilter = string.Empty;
            strExtension = Constants.SPO2_FILE_EXTENSION;
            strFilter = "SpO2 Files (*.spo2)|*.spo2|All files (*.*)|*.*";
            strPath = Application.StartupPath + "\\SPO2\\";
           
            openFlDialog.DefaultExt = strExtension;
            openFlDialog.AddExtension = true;

            openFlDialog.Filter = strFilter;
            openFlDialog.Multiselect = false;

            try
            {
                if (!Directory.Exists(strPath))
                {
                    Directory.CreateDirectory(strPath);

                }
            }
            catch (Exception objException)
            {
                string str = objException.Message;
            }
            openFlDialog.InitialDirectory = strPath;
            openFlDialog.ShowDialog();
        }
        #endregion
    }
}